/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************/

#ifdef __CSMC__
#include "S12P64.h"
#else
#include <hidef.h>		/* common defines and macros */
#include "derivative.h"		/* derivative-specific definitions */
#endif
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "EEEGlobals.h"
#include "EEEISRs.h"

#pragma CODE_SEG __NEAR_SEG NON_BANKED

static unsigned int *EEECopyStartP;
static unsigned long ActiveSectorStart; 
static unsigned long DFCopyStart;
static unsigned char WordCount;
static unsigned char ActiveSectorNum;

/*************************************************************************************/

interrupt void FlashCCISR(void)

 {

 /* Variable Declarations */
 
  unsigned char x;
 
 /* Begin Function FlashCCISR() */
 
 switch (EEEState) {
 
 case EEE_Erase:
   {
    FCNFG_CCIE = 0;		/* sector erase complete, disable interrupts */
    if (FSTAT & (FSTAT_ACCERR_MASK | FSTAT_FPVIOL_MASK | FSTAT_MGSTAT1_MASK | FSTAT_MGSTAT0_MASK))
     EEEError = EEE_EraseErr;
    else
     EEEError = EEE_noErr;
    EEEState = EEE_Idle;	/* EEE is in idle state */
    break;
   }
  
 case EEE_BlankCheck:
   {
    FCNFG_CCIE = 0;		/* sector blank check complete, disable interrupts */
    if (FSTAT & (FSTAT_ACCERR_MASK | FSTAT_FPVIOL_MASK | FSTAT_MGSTAT1_MASK | FSTAT_MGSTAT0_MASK))
     EEEError = EEE_BlankCheckErr;
    else
     EEEError = EEE_noErr;
    EEEState = EEE_Idle;	/* EEE is in idle state */
    break;
   }

 case EEE_RAMBufCopyInit:
  {
    ActiveSectorNum = *(unsigned char *)EEERAMStart & 0x0f;				/* get the active sector number from the first byte of the EE buffer */
    ActiveSectorStart = DFStart + GlobalOffset + (DFSectorSize * ActiveSectorNum);	/* global start address of the currently active sector */
    if (++ActiveSectorNum > DFMaxSectorNum)						/* index to the next active sector (where we will place the EEE RAM buffer) */
     ActiveSectorNum = 0;
    DFCopyStart = DFStart + GlobalOffset + (DFSectorSize * ActiveSectorNum + (DFSectorSize - 8));	/* we will begin programming the DFlash from the end of the sector. */
    EEECopyStartP = (unsigned int *)(EEERAMStart + DFSectorSize - 8);			/* we will begin copying from the end of the RAM buffer */
    WordCount = 128;
    EEEState = EEE_RAMBufCopy;					/* go to the sector copy state */
    FSTAT = FSTAT_ACCERR_MASK | FSTAT_FPVIOL_MASK;		/* clear errors from any previous commands */
    break;   
  }


 case EEE_RAMBufCopy:
   {
//    PORTA = 0x00;
    if ((FSTAT & (FSTAT_ACCERR_MASK | FSTAT_FPVIOL_MASK | FSTAT_MGSTAT1_MASK | FSTAT_MGSTAT0_MASK)) != 0)	/* errors in the previous program command? */
     {
      EEEError = EEE_ProgErr;		/* error occurred in previous program command */
      EEEState = EEE_Idle;		/* set the state to idle */
      FCNFG_CCIE = 0;			/* disable interrupts */
     }
    else
     {
      if (WordCount != 0)			/* if we're not done programming the new sector.... */
       {
        FCCOBIX = 0;				/* set the FCCOB index to the start of the FCCOB command buffer */
        FCCOB = (unsigned int)((DFProgramCmd << 8) + (((DFCopyStart) >> 16) & 0x00ff));		/* write the DFlash Program command & the upper 8 bits of the global address to the command buffer */
        FCCOBIX = 1;				/* set the FCCOB index to the next word of the FCCOB command buffer */
        FCCOB = DFCopyStart & 0xffff;		/* write the lower 16-bits of the DFlash Global address to the command buffer */
        if (WordCount > 4)
         {
          for (x = 0; x < 4; x++)
           {
            FCCOBIX = x + 2;			/* set the FCCOB index to the next word of the FCCOB command buffer */
            FCCOB = EEECopyStartP[x];		/* write a word of data from the EEE RAM buffer the the FCCOB command buffer */
           }
          WordCount -= 4;			/* subtract 4 from the word count */
          if (WordCount > 4)
           {
            DFCopyStart -= 8;			/* point to the next lower 8 bytes in the DFlash sector to be programmed */
            EEECopyStartP -= 4;			/* point to the next lower 8 bytes in the EEE RAM buffer to be programmed */
           }
         }
        else
         {
          if (WordCount == 4)
           {
            DFCopyStart -= 2;
            FCCOB = DFCopyStart & 0xffff;	/* rewrite the lower 16-bits of the DFlash Global address to the command buffer after the adjustment */
            EEECopyStartP -= 1;
           }
          FCCOBIX = 2;				/* set the FCCOB index to the next word of the FCCOB command buffer */
          FCCOB = *EEECopyStartP--;		/* write a word of data from the EEE RAM buffer the the FCCOB command buffer */
          if (WordCount == 1)			/* Are we about to program the first word in the sector? */
           FCCOB = (FCCOB & 0x00ff) + (ActiveSectorFlag << 8);	/* yes. the upper 8 bits contains the 'active sector' flag (0xaa) */
          DFCopyStart -= 2;			/* subtract 2 from the DFlash Global sector address (we program a word at a time, beginning at the end of the sector) */
          WordCount--;				/* decrement the word count */
         }
        FSTAT = FSTAT_CCIF_MASK;		/* launch the command and return */
       }
      else				/* RAM buffer copy complete, now we need to erase the previous sector */
       {
        //
	/* Note: at this point the address in DFCopyStart is pointing to the last word of the previous sector */
        //
        if (DFCopyStart < (DFStart + GlobalOffset))		/* if we just programmed data into the first sector, DFCopyStart will point below the DFlash array */
         DFCopyStart = (DFStart + DFSize + GlobalOffset) - 2;	/* so that means that the previous sector is actually the last sector in the array */
        *(unsigned char *)EEERAMStart = ActiveSectorNum;		/* update the EEE RAM buffer Status byte with the currently active sector number */
        FCCOBIX = 0;						/* set the FCCOB index to the start of the FCCOB command buffer */
        FCCOB = (unsigned int)((DFEraseSectorCmd << 8) + (((DFCopyStart) >> 16) & 0x00ff));		/* write the DFlash Sector Erase command & the upper 8 bits of the global address to the command buffer */
        FCCOBIX = 1;						/* set the FCCOB index to the next word of the FCCOB command buffer */
        FCCOB = DFCopyStart & 0xffff;				/* write the lower 16-bits of the DFlash Global address to the command buffer */
        EEEState = EEE_Erase; 
        FSTAT = FSTAT_CCIF_MASK;				/* launch command */
        
       }
      
     }
    break;   
   }

 case EEE_ProgData:
   {
    FCNFG_CCIE = 0;		/* data programming complete, disable interrupts */
    if (FSTAT & (FSTAT_ACCERR_MASK | FSTAT_FPVIOL_MASK | FSTAT_MGSTAT1_MASK | FSTAT_MGSTAT0_MASK))
     EEEError = EEE_ProgErr;
    else
     EEEError = EEE_noErr;
    EEEState = EEE_Idle;	/* EEE is in idle state */
    break;   
   }

  default:
   {
    FCNFG_CCIE = 0;
    EEEState = EEE_Idle;
    break;
   }

  }	/* end switch (EEEState) */

//  PORTA = 0x01;

 }	/* end FlashCCISR */

/*************************************************************************************/

interrupt void FlashErrorISR(void)

 {

 /* Variable Declarations */
 
 
 /* Begin Function FlashErrorISR() */
 
 /*  */

 }	/* end FlashErrorISR */

/*************************************************************************************/

#pragma CODE_SEG DEFAULT
